#pragma once

#include "Renderable.h"
#include <GL/glew.h>
#include <GL/GL.h>
#include <glm/glm.hpp>

namespace graphics {
	class SnakeMesh : public Renderable
	{
	public:
		SnakeMesh(unsigned int numIterations);
		SnakeMesh(const SnakeMesh & pyramid) = delete;
		SnakeMesh & operator = (const SnakeMesh & pyramid) = delete;
		~SnakeMesh();
		void render();
		void grow();
	
		GLuint m_VAO;
		/*
		0 -> vertex buffer
		1 -> index buffer
		*/
		GLuint m_buffers[3];
		static const unsigned MAX = 100000;
		glm::vec3 VERTICES[MAX+1];
		unsigned int INDICES[MAX+1];
		unsigned int numIndices;
		unsigned int numVertices;
		glm::vec3 getRandomPoint(float r);
		glm::vec3 xAxis;
		glm::vec3 yAxis;
		unsigned int m_numIterations;
		float yMax;
	};
};

